                                                                              
;****************************************************************************;
;*                                                                          *;
;*                             "Storm Warrior"                              *;
;*                                                                          *;
;*                 Source Code (c) Copyright Paul Hughes 1989               *;
;*                                                                          *;
;* Released into the Public Domain 27 May 2018.  Do with it what you will.  *;
;* If you make something with any of the code, a mention would be nice, but *;
;* isn't required.                                                          *;
;*                                                                          *;
;* I'll happily try to explain things, but remember the code is almost 30   *;
;* years old, the understanding of the C64 has come a long way, and it was  *;
;* written by a somewhat hubristic 20 year old me.                          *;
;*                                                                          *;
;****************************************************************************;

TRUE           EQU 1                    ;conditional control codes
FALSE          EQU 0
YES            EQU TRUE
NO             EQU FALSE

SHOW_RASTER    EQU NO                   ;should rasters be displayed

BLACK          EQU 0                    ;c64 colour codes
WHITE          EQU 1
RED            EQU 2
CYAN           EQU 3
PURPLE         EQU 4
GREEN          EQU 5
BLUE           EQU 6
YELLOW         EQU 7
ORANGE         EQU 8
BROWN          EQU 9
PINK           EQU 10
DGREY          EQU 11
MGREY          EQU 12
LGREEN         EQU 13
LBLUE          EQU 14
LGREY          EQU 15

SPY            EQU $D001                ;vic chip sprite Y base
SPX            EQU $D000                ;vic chip sprite X base
VIC_COLOUR     EQU $D027                ;vic chip sprite colour base
RASTDIF        EQU 21                   ;plexor time before new raster
NSP            EQU 32                   ;number of sprites

FIRST_RAST     EQU $FA                  ;first raster interrupt position

05_SECS        EQU 05*50                ;time EQUates for 50hz
10_SECS        EQU 10*50
15_SECS        EQU 15*50
20_SECS        EQU 20*50

P1_X_MIN       EQU $024                 ;player stopping points
P1_X_MAX       EQU $132
P1_Y_MIN       EQU $030
P1_Y_MAX       EQU $0E0

;-----------------------------------------------------------------------------
;zero page.

ZP             EQU 2                    ;zero page base address

               ORG ZP
IA             DFB 0                    ;Interrupt temps
IX             DFB 0                    ;     "       "
IY             DFB 0                    ;     "       "
SY2            DFS NSP,0                ;sprite Y
SX             DFS NSP,0                ;sprite X
X_MSB_2        DFS NSP,0                ;sprite X MSB
SPRITE_C       DFS NSP,0                ;sprite colour
SPRITE_P       DFS NSP,0                ;sprite pointer
POINTER        DFS NSP,0                ;list of sorted pointers to sprite Y
TX             DFB 0                    ;temporary
TY             DFB 0                    ;   "     "
CNT            DFB 0                    ;multiplexor shift depth variable
RASTEMP        DFB 0                    ;accumulated M/PLEX raster depth
NXTSP          DFB 0                    ;next multiplexor sprite
NXTSPR         DFB 0                    ;next Vic sprite
X_OFFSET       DFB 0                    ;indeces within sine tables
Y_OFFSET       DFB 0                    ;   "       "     "     "
FROM           DFW 0                    ;general purpose
TO             DFW 0                    ;general purpose
SAVEA          DFB 0                    ;temps
SAVEX          DFB 0                    ;temps
SAVEY          DFB 0                    ;temps

FRONT_SCR      DFW 0                    ;indirect address of character bullets
FRONT_TMP      DFW 0                    ;on Front and Back screens
BACK_SCR       DFW 0
BACK_TMP       DFW 0

X_FINE         DFB 0                    ;smooth x values
X_FINE_2       DFB 0
SCRBASE        DFB 0                    ;screen base address pointer
FLIP_FLAG      DFB 0                    ;flag to signal screen flipping
MAP            DFW 0                    ;indirect map address
BLOCK          DFW 0                    ;indirect block address
CALC           DFW 0                    ;calaculation word
HORPOS_L       DFB 0                    ;horizontal position within the map
HORPOS_H       DFB 0
BLOCK_DEPTH    DFB 0                    ;counter, number of blocks down

DATA_BASE      DFW 0                    ;baddy flight paths database

MY_X           DFB 0                    ;variables for collision detection
HIS_X          DFB 0                    ;    "      "      "         "
HIS_Y          DFB 0                    ;    "      "      "         "
BUL_X          DFB 0                    ;    "      "      "         "
BUL_Y          DFB 0                    ;    "      "      "         "

;-----------------------------------------------------------------------------
;variables

               ORG $0200

SPRITE_X       DFS NSP,0                ;sprite X buffer
SPRITE_Y       DFS NSP,0                ;sprite Y buffer
X_MSB          DFS NSP,0                ;sprite X MSB buffer

LASTCOUNT      DFB 0                    ;variables used in flyback syncs
LASTVAL        DFB 0

Y_INDEX        DFB 0
TEMP           DFW 0

OLD_JOY        DFB 0                    ;last joystick value

P1_ANIM_COUNT  DFB 0                    ;animation phase counter (player)

FIRE_STATE     DFB 0                    ;current fire button status
OLD_FIRE_STATE DFB 0                    ;last fire button status

DEATH_FLAG     DFB 0                    ;whether player is exploding
DEATH_COUNT    DFB 0                    ;counter between explosion frames

INVINCE_FLAG   DFB 0                    ;invincibility flag for player
INVIN_COUNT    DFB 0                    ;counter for length of invincibility

SCROLL_FLAG    DFB 0                    ;scroll active flag

;----

P1_MAX_BULS    EQU 19                   ;maximum number of player bullets

P1_BUL_FLAGS   DFS P1_MAX_BULS,0        ;player bullet active flags
P1_BUL_X       DFS P1_MAX_BULS,0        ;player bullet x coordinates
P1_BUL_Y       DFS P1_MAX_BULS,0        ;player bullet y coordinates

;----
;normal baddy vars

FIN            EQU 0                    ;terminate pattern control code
LOOP           EQU $FE                  ;loop pattern control code
STOP_SCROLL    EQU $FD                  ;scroll stop control code

ALIENS         EQU 15                   ;maximum number of aliens on screen
ALIEN_ON       DFS ALIENS,0             ;alien active
INTRO_COUNT    DFS ALIENS,0             ;introduction delay counter
EXPLODE_FLAGS  DFS ALIENS,0             ;alien exploding flags
X_VELS         DFS ALIENS,0             ;alien x velocities
Y_VELS         DFS ALIENS,0             ;alien y velocities
ANIM_L         DFS ALIENS,0             ;alien animation address low
ANIM_H         DFS ALIENS,0             ;alien animation address high
BADDY_Y        DFS ALIENS,0             ;baddy intial y position
BADDY_COLOUR   DFS ALIENS,0             ;baddy colour
PATHS_L        DFS ALIENS,0             ;flight path address low
PATHS_H        DFS ALIENS,0             ;flight path address high
INTRO_TEMP     DFS ALIENS,0             ;temporary introduction delay
BADDY_Y_TEMP   DFS ALIENS,0             ;   "       initial y position
BADDY_C_TEMP   DFS ALIENS,0             ;   "       colour
ADDR_TEMP_L    DFS ALIENS,0             ;   "   path address low
ADDR_TEMP_H    DFS ALIENS,0             ;   "   path address high
BADDY_COUNT    DFS ALIENS,0             ;aleien velocitiy counters
ANIM_INDEX     DFS ALIENS,0             ;alien animation indexes
DESTROY_SHOTS  DFS ALIENS,0             ;number of alien kill shots
ANIM_TEMP_L    DFS ALIENS,0             ;temporary animation address low
ANIM_TEMP_H    DFS ALIENS,0             ;   "         "         "    high
SHOTS_TEMP     DFS ALIENS,0             ;   "   number of alien kill shots
ANIM_COUNT     DFS ALIENS,0             ;alien animation phase delays
EXPL_COUNT     DFS ALIENS,0             ;alien explosion phase counters
ALNUM          DFB 0                    ;number of aliens in formation var

;----
;big baddy vars

BIG_LEFT_CLIP  EQU 004                  ;big baddy clipping yules
BIG_RIGHT_CLIP EQU 334
BIG_TOP_CLIP   EQU $1C
BIG_BOT_CLIP   EQU $E0

BIGGY_MAX      EQU 15                   ;maximum number of sprites for biggies

BIGGY_FLAG     DFB 0                    ;big baddy active flag
BIGGY_X        DFB 0                    ;big baddy master coordinates
BIGGY_X_MSB    DFB 0                    ;big baddy master coordinates
BIGGY_Y        DFB 0
BIGGY_SIZE     DFB 0                    ;current size of biggy
BIGGY_X_OFF    DFS BIGGY_MAX,0          ;biggy X offsets
BIGGY_Y_OFF    DFS BIGGY_MAX,0          ;biggy Y offsets
BIGGY_P        DFS BIGGY_MAX,0          ;biggy pointers
BIGGY_C        DFS BIGGY_MAX,0          ;biggy colours
BIGGY_HITS     DFS BIGGY_MAX,0          ;number of hits on biggy
BIGGY_ANIM_L   DFS BIGGY_MAX,0
BIGGY_ANIM_H   DFS BIGGY_MAX,0
BIGGY_ANI_FLAG DFS BIGGY_MAX,0
BIGGY_ANI_IND  DFS BIGGY_MAX,0

BIG_ANIM_CNT   DFB 0
BIGGY_X_VEL    DFB 0                    ;big baddy x velocity
BIGGY_Y_VEL    DFB 0                    ;big baddy y velocity
BIG_BAD_COUNT  DFB 0                    ;big baddy velocity counter
BIG_BAD_PATH   DFW 0                    ;indirect address of baddy pattern
BIGGY_DEATH    DFB 0                    ;flag to say whether bigy is dead

FIRE_BUL       EQU $FF                  ;bullet fire control code
BADDY_BUL_MAX  EQU 4                    ;maximum number of alien bullets

BAD_BUL_FLAGS  DFS BADDY_BUL_MAX,0      ;alien bullet active flags
FIRING_SPRITE  DFS BADDY_BUL_MAX,0      ;which sprite fires the bullet
BUL_X_VEL      DFS BADDY_BUL_MAX,0      ;alien bullet x velocity
BUL_Y_VEL      DFS BADDY_BUL_MAX,0      ;alien bullet y velocity

;-----------------------------------------------------------------------------

               ORG $0500

;-----------------------------------------------------------------------------
;the beginning!

               ENT

START          SEI                      ;stop interrupts
               LDX #$FF
               TXS                      ;reset the stack

               LDA #$35                 ;roms out
               STA 1

               JSR VAR_CLOBBER          ;clobber all the variables !
               JSR SETBANK              ;set into Display Bank 3 ($C000)
               JSR SETRAST              ;initialise raster interrupts
               JSR SETUP                ;initialise multiplexor
               JSR GEN_TIMES_16         ;generate "Times 16" table
               JSR WARM_START           ;Init player sprite, colours etc..

;-----------------------------------------------------------------------------
;
; MAIN_LOOP - The game control loop
;             first part of loop is generalised routines, scroll etc
;             second loop is for normal baddy processing
;             third part handles the big baddies
;

MAIN_LOOP      JSR FX_19                ;lock to a frame

; DEC $D020

               JSR SCROLL               ;shunt 3 lines at a time

               JSR FLIP_SCREEN          ;flip the screen base

               JSR SWOP_BUFFERS         ;swop the smooth scroll buffers

               JSR JOY_STICK            ;process player movement & animation

               JSR DO_FIRE              ;process player bullet firing

               JSR EXPLODE_ME           ;process my explosion

               JSR DO_INVINCIBLE        ;flash me during invincibility

               JSR BADDY_BULLETS        ;process alien bullets

               JSR BULLET_COLLIDE       ;process alien bullets hitting player

;----

               LDA #60
               JSR KEYSCAN
               BCC 2$

               LDA #0
               JSR INIT_BIGGY

2$             LDA BIGGY_FLAG           ;see if a big baddy is activated
               BNE BIG_MAIN

;-----
;generalised normal baddy routines loop

               JSR DO_BADDIES           ;do normal baddy movement

               JSR ANIMATE_BADS         ;do normal baddy animation

               JSR ALIEN_COLLIDE        ;do normal alien collisions

               JSR ALIEN_EXPLODE        ;do normal alien explosions

; INC $D020

               JMP MAIN_LOOP

;-----
;big baddy general routines loop

BIG_MAIN       JSR BIG_BADDIES          ;do big baddy movement

               JSR BIG_COLLISIONS       ;do big baddy collisions

               JSR BIG_ANIMATE          ;do big baddy animation

               JSR BIGGY_EXPLODE        ;do big baddy explosion

; INC $D020

               JMP MAIN_LOOP

;-----------------------------------------------------------------------------
;
; SWOP_BUFFERS - Swops over any hardware double buffers
;

SWOP_BUFFERS   LDA X_FINE
               STA X_FINE_2
               RTS

;-----------------------------------------------------------------------------
;
; CLEAR_SCREENS - Clears the physical and logical screen to a blank
;                 Clears colour ram with the colour in (A)
;

CLEAR_SCREENS  STA COLOUR_MOD_1+1
               LDX #0
               LDA #$20
CLR_S          STA $C800,X
               STA $C900,X
               STA $CA00,X
               STA $CB00,X
               STA $CC00,X
               STA $CD00,X
               STA $CE00,X
               STA $CF00,X
               INX
               BNE CLR_S
COLOUR_MOD_1   LDA #$AA                 ;self modified
CLR_A          STA $D800,X
               STA $D900,X
               STA $DA00,X
               STA $DB00,X
               INX
               BNE CLR_A

               LDA #$20
               STA SCRBASE
               RTS

;-----------------------------------------------------------------------------
;
; CLS - Clears the logical screen ($C800)
;

CLS            LDX #0
               LDA #$20
CLS_2          STA $C800,X
               STA $C900,X
               STA $CA00,X
               STA $CB00,X
               INX
               BNE CLS_2
               RTS

;-----------------------------------------------------------------------------
;
; JOY_STICK - Processes player movement and animation
;

JOY_STICK      LDA DEATH_FLAG
               BEQ READ_JOY
               RTS

READ_JOY       LDA $DC00
               STA FIRE_STATE
               EOR #$1F
               AND #$1F
               BEQ NO_MOVE
               STA OLD_JOY
               AND #1
               BEQ NO_UP
               JSR PLAYER_UP
NO_UP          LDA OLD_JOY
               AND #2
               BEQ NO_DOWN
               JSR PLAYER_DOWN
NO_DOWN        LDA OLD_JOY
               AND #4
               BEQ NO_LEFT
               JSR PLAYER_LEFT
NO_LEFT        LDA OLD_JOY
               AND #8
               BEQ NO_RIGHT
               JSR PLAYER_RIGHT
NO_RIGHT       RTS

;-----

NO_MOVE        LDA P1_ANIM_COUNT        ;no movement, so centralise the craft
               ADD #1
               AND #3
               STA P1_ANIM_COUNT
               BNE NO_P1_PHASE
               LDA SPRITE_P
               CMP #$43
               BEQ NO_P1_PHASE
               BCC DOWNWARD_PHASE
               JMP UPWARD_PHASE
NO_P1_PHASE    RTS

;-----

PLAYER_LEFT    LDA X_MSB                ;if over MSB it's impossible to be
               BNE NO_CHECK_L           ;near the left edge
               LDA SPRITE_X
               CMP #P1_X_MIN
               BCC STOP_LEFT
NO_CHECK_L     LDA SPRITE_X
               SUB #2
               STA SPRITE_X
               BCS STOP_LEFT
               DEC X_MSB
STOP_LEFT      RTS

;----

PLAYER_RIGHT   LDA X_MSB                ;if under MSB it's impossible to be
               BEQ NO_CHECK_R           ;near the right edge
               LDA SPRITE_X
               CMP #P1_X_MAX
               BCS STOP_RIGHT
NO_CHECK_R     LDA SPRITE_X
               ADD #2
               STA SPRITE_X
               BCC STOP_RIGHT
               INC X_MSB
STOP_RIGHT     RTS

;----

PLAYER_UP      LDA SPRITE_Y
               CMP #P1_Y_MIN
               BCC STOP_TOP
               SUB #2
               STA SPRITE_Y
               LDA P1_ANIM_COUNT        ;animation delay counter
               ADD #1
               AND #3
               STA P1_ANIM_COUNT
               BNE STOP_TOP
DOWNWARD_PHASE LDA SPRITE_P
               CMP #$46
               BEQ STOP_TOP
               INC SPRITE_P
STOP_TOP       RTS

;----

PLAYER_DOWN    LDA SPRITE_Y
               CMP #P1_Y_MAX
               BCS STOP_BOT
               ADD #2
               STA SPRITE_Y
               LDA P1_ANIM_COUNT        ;animation delay counter
               ADD #1
               AND #3
               STA P1_ANIM_COUNT
               BNE STOP_BOT
UPWARD_PHASE   LDA SPRITE_P
               CMP #$40
               BEQ STOP_BOT
               DEC SPRITE_P
STOP_BOT       RTS

;-----------------------------------------------------------------------------
;
; EXPLODE_ME -
;

EXPLODE_ME     LDA DEATH_FLAG
               BNE I_AM_DEAD
               RTS

I_AM_DEAD      LDA DEATH_COUNT
               ADD #1
               AND #3
               STA DEATH_COUNT
               BEQ NEXT_PHASE
               RTS

NEXT_PHASE     LDA SPRITE_P
               CMP #$64
               BEQ EXPLODE_OVER
               INC SPRITE_P
               RTS

EXPLODE_OVER   LDA #$43
               STA SPRITE_P
               LDX #0
               STX DEATH_FLAG
               INX
               STX INVINCE_FLAG
               LDA #150
               STA INVIN_COUNT
               RTS

;-----------------------------------------------------------------------------
;
; DO_INVINCIBLE - flashes the player's ship during invincibility
;

DO_INVINCIBLE  LDA INVINCE_FLAG
               BNE INVIN_SET
               RTS

INVIN_SET      DEC INVIN_COUNT
               BEQ INVIN_OVER

               LDA PULSE_COUNT
               ADD #1
               AND #3
               STA PULSE_COUNT
               BEQ NEXT_COLOUR
               RTS

NEXT_COLOUR    LDA PULSE_INDEX
               ADD #1
               AND #7
               STA PULSE_INDEX
               TAX
               LDA PULSE_TABLE,X
               STA SPRITE_C
               RTS

INVIN_OVER     LDA #0
               STA INVINCE_FLAG
               LDA #LBLUE
               STA SPRITE_C
               RTS

;-----
PULSE_INDEX    DFB 0
PULSE_COUNT    DFB 0
PULSE_TABLE    DFB DGREY,MGREY,LGREY,WHITE,WHITE,LGREY,MGREY,DGREY

;-----------------------------------------------------------------------------
;
; DO_FIRE -
;

DO_FIRE        LDA DEATH_FLAG
               BEQ CHECK_FIRE
               RTS

CHECK_FIRE     LDA FIRE_STATE           ;debounce fire button
               AND #$10
               BNE NO_FIRE
               CMP OLD_FIRE_STATE
               BNE NEW_PRESS
NO_FIRE        STA OLD_FIRE_STATE
               RTS

NEW_PRESS      STA OLD_FIRE_STATE

               LDA SPRITE_Y             ;work out where gun on the ship is
               SUB #40                  ;in relation to the screen
               LSR 
               LSR 
               LSR 
               TAY                      ;Y=Y coord

               LDA X_MSB
               STA TEMP+1
               LDA SPRITE_X
               SUB #24
               STA SKIP_C+1             ;(X-24) low byte
               BCS SKIP_C
               DEC TEMP+1
SKIP_C         LDA #0                   ;modified
               LSR TEMP+1
               ROR 
               LSR TEMP+1
               ROR 
               LSR TEMP+1
               ROR 
               STA FOUND_FREE+1         ;preserve X coord

               LDX #P1_MAX_BULS-1
FIND_FREE      LDA P1_BUL_FLAGS,X
               BEQ FOUND_FREE
               DEX
               BPL FIND_FREE
               RTS

FOUND_FREE     LDA #0                   ;modified x coordinate
               STA P1_BUL_X,X
               TYA
               STA P1_BUL_Y,X
               LDA #1
               STA P1_BUL_FLAGS,X
               RTS

;-----------------------------------------------------------------------------
;
; BULLET_COLLIDE - Process collision between baddy bullets and player
;

BULLET_COLLIDE LDA DEATH_FLAG
               BEQ NOT_DEAD
               RTS

NOT_DEAD       LDA INVINCE_FLAG
               BEQ OK_CAN_KILL
               RTS

OK_CAN_KILL    LDA X_MSB
               LSR 
               LDA SPRITE_X
               ROR 
               STA MY_X

               LDX #BADDY_BUL_MAX-1
BUL_COLL       LDA X_MSB+24,X           ;bullet MSB
               LSR 
               LDA SPRITE_X+24,X        ;bullet X
               ROR 
               STA HIS_X
               LDA SPRITE_Y+24,X
               STA HIS_Y

               LDA MY_X                 ;my x
               ADD #12
               CMP HIS_X                ;bullet x
               BCC NO_HIT
               SUB #24
               CMP HIS_X
               BCS NO_HIT
               LDA SPRITE_Y             ;my y
               ADD #12
               CMP HIS_Y                ;bullet y
               BCC NO_HIT
               SUB #28
               CMP HIS_Y
               BCS NO_HIT

               LDA #1                   ;I hit the bullet
               STA DEATH_FLAG
               LDA #$5B
               STA SPRITE_P
               LDA #0                   ;switch this bullet off
               STA SPRITE_Y+24,X
               STA SPRITE_X+24,X
               STA X_MSB+24,X
               STA BAD_BUL_FLAGS,X

NO_HIT         DEX
               BPL BUL_COLL
               RTS

;-----------------------------------------------------------------------------
;
; DO_BADDIES - Processes all normal baddy attack patterns
;

DO_BADDIES     LDY #0
               LDA (DATA_BASE),Y        ;see if map counter is the same as
               CMP HORPOS_L
               BNE NO_NEW_PATH          ;the map value in the database
               INY
               LDA (DATA_BASE),Y
               CMP HORPOS_H
               BNE NO_NEW_PATH

               JSR SET_BADS             ;if not process any active baddies

NO_NEW_PATH    LDX #ALIENS-1
FIND_ON        LDA ALIEN_ON,X           ;find a free baddy
               BNE BADDY_ON
               DEX
               BPL FIND_ON
               RTS

BADDY_ON       LDA INTRO_COUNT,X        ;countdown the introduction value
               BEQ DO_INTRODUCE
               DEC INTRO_COUNT,X
               DEX
               BPL FIND_ON
               RTS

DO_INTRODUCE   LDA ALIEN_ON,X           ;see if alien needs initialising
               BMI INTRO_BADDY

MOVE_BADDY     LDA EXPLODE_FLAGS,X      ;is the alien exploding ?
               BNE NEXT_BADDY

COLOURS        LDA BADDY_COLOUR,X       ;always update the alien colour
               STA SPRITE_C+04,X        ;in case it flashed during collision

Y_VELOCITIES   LDA SPRITE_Y+4,X         ;add the new velocities to the
               ADD Y_VELS,X
               STA SPRITE_Y+4,X         ;sprite coordinates (no y clipping)

X_VELOCITIES   LDA X_VELS,X
               BMI NVE_VELOCITY
               ADD SPRITE_X+4,X         ;do x velocities
               STA SPRITE_X+4,X         ;(with left edge clipping)
               BCC DONT_CLIP
               INC X_MSB+4,X

DONT_CLIP      DEC BADDY_COUNT,X        ;decrement the velocity counter
               BEQ NEW_VELS

NEXT_BADDY     DEX
               BPL FIND_ON
               RTS
;
NVE_VELOCITY   EOR #$FF                 ;neg velocity
               ADD #1
               STA TEMP
               LDA SPRITE_X+4,X
               SUB TEMP
               STA SPRITE_X+4,X
               BCS NO_MSB
               DEC X_MSB+4,X

NO_MSB         LDA X_MSB+4,X            ;if MSB set alien can't be near left
               BNE DONT_CLIP            ;left edge, so clipping is irrelevant
               LDA SPRITE_X+4,X
               CMP #4
               BCS DONT_CLIP
               JMP CLIP_OFF             ;hit left edge clipping boundary

;-----

INTRO_BADDY    LDA #1                   ;alien on, introduction off
               STA ALIEN_ON,X

               LDA #$58                 ;initial alien x value
               STA SPRITE_X+4,X
               LDA #1
               STA X_MSB+4,X

               LDA BADDY_Y,X            ;baddy y value
               STA SPRITE_Y+4,X

               LDA BADDY_COLOUR,X       ;baddy colour
               STA SPRITE_C+4,X

               LDA ANIM_L,X             ;baddy animation table address
               STA FROM
               LDA ANIM_H,X
               STA FROM+1

               LDY #0
               LDA (FROM),Y
               STA SPRITE_P+4,X         ;baddy pointer

NEW_VELS       LDA PATHS_L,X            ;get baddy attack path address
               STA FROM
               LDA PATHS_H,X
               STA FROM+1

               LDY #0                   ;get the next velocities
               LDA (FROM),Y
               BEQ CLIP_OFF             ;0 = Terminator

               CMP #LOOP                ;should the pattern be looped ?
               BEQ LOOP_PATH            ;yes

GET_COUNTER    STA BADDY_COUNT,X
               INY
               LDA (FROM),Y
               STA X_VELS,X
               INY
               LDA (FROM),Y
               STA Y_VELS,X

               LDA PATHS_L,X            ;add 3 to pattern address
               ADD #3
               STA PATHS_L,X
               BCC SKP
               INC PATHS_H,X
SKP            DEX
               BMI ALL_DONE
               JMP FIND_ON
ALL_DONE       RTS

CLIP_OFF       LDA #0                   ;switch alien off
               STA ALIEN_ON,X
               STA SPRITE_Y+4,X
               STA SPRITE_X+4,X
               STA X_MSB+4,X
               DEX
               BMI ALL_DONE
               JMP FIND_ON

;-----

LOOP_PATH      INY                      ;loop to new path address
               LDA (FROM),Y
               STA PATHS_L,X
               INY
               LDA (FROM),Y
               STA PATHS_H,X
               JMP NEW_VELS

;-----

SET_BADS       LDY #2                   ;get formation address
               LDA (DATA_BASE),Y
               STA FROM
               INY
               LDA (DATA_BASE),Y
               STA FROM+1

               LDA DATA_BASE            ;Add 4 to formation database
               ADD #4
               STA DATA_BASE
               BCC SKIP
               INC DATA_BASE+1

SKIP           LDY #0
               LAX (FROM),Y
               BNE NORMAL_BADDY
               JMP TRIGGER_BIGGY        ;0 = big baddy trigger

NORMAL_BADDY   STA ALNUM                ;No of aliens in this formation
GET_BADDY      INY
               LDA (FROM),Y
               STA INTRO_TEMP,X         ;Introduction counter
               INY
               LDA (FROM),Y
               STA BADDY_Y_TEMP,X       ;Y coordinate
               INY
               LDA (FROM),Y
               STA BADDY_C_TEMP,X       ;Colour
               INY
               LDA (FROM),Y
               STA ADDR_TEMP_L,X        ;Pattern address
               INY
               LDA (FROM),Y
               STA ADDR_TEMP_H,X        ;   "       "
               INY
               LDA (FROM),Y
               STA ANIM_TEMP_L,X        ;animation table address
               INY
               LDA (FROM),Y
               STA ANIM_TEMP_H,X        ;    "       "      "
               INY
               LDA (FROM),Y
               STA SHOTS_TEMP,X         ;no of shots to kill a baddy
               DEX
               BNE GET_BADDY

               LDY ALNUM
FIND_ALIEN     LDX #ALIENS-1
SEARCH         LDA ALIEN_ON,X           ;find a free alien to use
               BEQ FOUND_FREE_2
               DEX
               BPL SEARCH
               RTS

FOUND_FREE_2   LDA #$80                 ;alien on & introduce
               STA ALIEN_ON,X
               LDA ADDR_TEMP_L,Y
               STA PATHS_L,X
               LDA ADDR_TEMP_H,Y
               STA PATHS_H,X
               LDA BADDY_Y_TEMP,Y       ;pass on attack attributes
               STA BADDY_Y,X
               LDA BADDY_C_TEMP,Y
               STA BADDY_COLOUR,X
               LDA INTRO_TEMP,Y
               STA INTRO_COUNT,X
               LDA ANIM_TEMP_L,Y
               STA ANIM_L,X
               LDA ANIM_TEMP_H,Y
               STA ANIM_H,X
               LDA #0
               STA ANIM_INDEX,X
               LDA SHOTS_TEMP,Y
               STA DESTROY_SHOTS,X
               DEY
               BNE FIND_ALIEN
               RTS

;----

TRIGGER_BIGGY  INY
               LDA (FROM),Y             ;big baddy Number
               JMP INIT_BIGGY

;-----------------------------------------------------------------------------
;
; ALIEN_COLLIDE - Handles collision between player, baddies & bullets
;

ALIEN_COLLIDE  LDA DEATH_FLAG           ;am i exploding ?
               BEQ DO_COLL_1
               JMP P1_BULLET_COL        ;just process my bullet collision

DO_COLL_1      LDA INVINCE_FLAG         ;am i invincible ?
               BEQ NOT_INV
               JMP P1_BULLET_COL        ;just process my bullet collision

NOT_INV        LDA X_MSB                ;collision, player to big baddy
               LSR 
               LDA SPRITE_X
               ROR 
               STA MY_X_MOD_1+1

               LDX #ALIENS-1            ;number of aliens
ALIEN_COL      LDA X_MSB+04,X           ;baddy MSB
               LSR 
               LDA SPRITE_X+04,X        ;baddy X
               ROR 
               STA HIS_X_MOD_1+1
               STA HIS_X_MOD_2+1
               LDA SPRITE_Y+04,X
               STA HIS_Y_MOD_1+1
               STA HIS_Y_MOD_2+1

MY_X_MOD_1     LDA #0                   ;my x
               ADD #12
HIS_X_MOD_1    CMP #0                   ;baddy x
               BCC NO_COLL
               SBC #24
HIS_X_MOD_2    CMP #0                   ;baddy x
               BCS NO_COLL
               LDA SPRITE_Y             ;my y
               ADC #16
HIS_Y_MOD_1    CMP #0                   ;baddy y
               BCC NO_COLL
               SBC #32
HIS_Y_MOD_2    CMP #0                   ;baddy y
               BCS NO_COLL

               LDA EXPLODE_FLAGS,X      ;no death to player if exploding
               BNE NO_COLL

               LDA #1                   ;I hit the baddy
               STA DEATH_FLAG
               LDA #$5B
               STA SPRITE_P

NO_COLL        DEX
               BPL ALIEN_COL
;----
P1_BULLET_COL  LDY #P1_MAX_BULS-1       ;collision, player bullets & baddy
FIND_BULS      LDA P1_BUL_FLAGS,Y
               BNE BUL_ON
               DEY
               BPL FIND_BULS
               RTS

BUL_ON         LDX P1_BUL_X,Y
               LDA BUL_X_LOOKUP,X       ;character to sprite x lookup
               STA BUL_X_MOD_1+1
               LDX P1_BUL_Y,Y
               LDA BUL_Y_LOOKUP,X       ;character to sprite y lookup
               STA BUL_Y

               LDX #ALIENS-1
BUL_COLLIDE_1  LDA X_MSB+04,X
               LSR 
               LDA SPRITE_X+04,X
               ROR 
               STA HIS_X_MOD_1A+1
               STA HIS_X_MOD_2A+1
               LDA SPRITE_Y+04,X
               STA HIS_Y_MOD_1A+1
               STA HIS_Y_MOD_2A+1

BUL_X_MOD_1    LDA #0                   ;my bullet x
               ADD #4
HIS_X_MOD_1A   CMP #0                   ;baddy x
               BCC NO_HIT_3
               SBC #8
HIS_X_MOD_2A   CMP #0                   ;baddy x
               BCS NO_HIT_3
               LDA BUL_Y                ;my bullet y
               ADC #8
HIS_Y_MOD_1A   CMP #0                   ;baddy y
               BCC NO_HIT_3
               SBC #24
HIS_Y_MOD_2A   CMP #0                   ;baddy y
               BCS NO_HIT_3

               LDA EXPLODE_FLAGS,X      ;already exploding
               BNE NO_HIT_3
               LDA #$80                 ;hit
               STA P1_BUL_FLAGS,Y       ;shut down bullet
               LDA DESTROY_SHOTS,X      ;enough hits to kill ?
               BEQ ALIEN_IS_DEAD
               DEC DESTROY_SHOTS,X      ;no
               INC SPRITE_C+04,X        ;flash alien to indicate a hit

NO_HIT_3       DEX
               BPL BUL_COLLIDE_1
               DEY
               BPL FIND_BULS
               RTS

ALIEN_IS_DEAD  LDA #1                   ;trigger the ig baddy explosion
               STA EXPLODE_FLAGS,X
               LDA #$5B
               STA SPRITE_P+04,X        ;explosion pointer
               BNE NO_HIT_3             ;always

;-----------------------------------------------------------------------------
;
; ALIEN_EXPLODE - Processes aliens exploding
;

ALIEN_EXPLODE  LDX #ALIENS-1
FIND_EXPL      LDA EXPLODE_FLAGS,X
               BNE IS_EXPL
               DEX
               BPL FIND_EXPL
               RTS

IS_EXPL        LDA EXPL_COUNT,X
               ADD #1
               AND #3
               STA EXPL_COUNT,X
               BEQ NEXT_FRAME
               DEX
               BPL FIND_EXPL
               RTS

NEXT_FRAME     LDA SPRITE_P+04,X
               CMP #$64
               BEQ EXPL_OVER
               INC SPRITE_P+04,X
               DEX
               BPL FIND_EXPL
               RTS

EXPL_OVER      LDA #0
               STA SPRITE_X+04,X
               STA SPRITE_Y+04,X
               STA X_MSB+04,X
               STA EXPLODE_FLAGS,X
               STA ALIEN_ON,X
               DEX
               BPL FIND_EXPL
               RTS

;-----------------------------------------------------------------------------
;
; ANIMATE_BADS - Processes the animation of the baddies
;

ANIMATE_BADS   LDX #ALIENS-1
TRY_THIS       LDA ALIEN_ON,X           ;alien active ?
               BNE DO_THIS
               DEX
               BPL TRY_THIS
               RTS

DO_THIS        LDA EXPLODE_FLAGS,X      ;is the alien exploding ?
               BEQ CAN_DO
               DEX
               BPL TRY_THIS
               RTS

CAN_DO         LDA ANIM_COUNT,X         ;need a new frame yet ?
               ADD #1
               AND #3
               STA ANIM_COUNT,X
               BEQ DO_NEXT_FRAME
               DEX
               BPL TRY_THIS
               RTS

DO_NEXT_FRAME  LDA ANIM_L,X             ;get the animation table address
               STA FROM
               LDA ANIM_H,X
               STA FROM+1

DOFRAME        LDY ANIM_INDEX,X         ;get the index within the table
               LDA (FROM),Y
               BEQ RESET_INDEX
               STA SPRITE_P+4,X         ;update the pointer
               INC ANIM_INDEX,X
               DEX                      ;next baddy
               BPL TRY_THIS
               RTS

RESET_INDEX    LDA #0                   ;reset the index within the table
               STA ANIM_INDEX,X
               BEQ DOFRAME              ;always

;-----------------------------------------------------------------------------
;
; BADDY_BULLETS - processes alien bullet control and animation
;

BADDY_BULLETS  LDX #BADDY_BUL_MAX-1
SEARCH_BAD_BUL LDA BAD_BUL_FLAGS,X
               BNE BAD_BUL_ON
               DEX
               BPL SEARCH_BAD_BUL
               RTS

BAD_BUL_ON     BPL BULLET_SET
               JMP SET_BAD_BUL

BULLET_SET     LDA BUL_X_VEL,X
               BMI NVE_X_VEL
               ADD SPRITE_X+24,X
               STA SPRITE_X+24,X
               BCC TEST_CLIP
               INC X_MSB+24,X
TEST_CLIP      LDA X_MSB+24,X           ;msb clr so can't be near right edge
               BEQ DO_Y_VELS
               CMP #74
               BCC DO_Y_VELS
               LDA #0
               STA SPRITE_X+24,X
               STA SPRITE_Y+24,X
               STA BAD_BUL_FLAGS,X
NEXT_BAD_BUL   DEX
               BPL SEARCH_BAD_BUL
               RTS

NVE_X_VEL      EOR #$FF
               ADD #1
               STA TEMP
               LDA SPRITE_X+24,X
               SUB TEMP
               STA SPRITE_X+24,X
               BCS TEST_CLIP_2
               DEC X_MSB+24,X
TEST_CLIP_2    LDA X_MSB+24,X           ;msb set so can't be near left edge
               BNE DO_Y_VELS
               LDA SPRITE_X+24,X
               CMP #10
               BCS DO_Y_VELS
               LDA #0
               STA SPRITE_Y+24,X
               STA BAD_BUL_FLAGS,X
               JMP NEXT_BAD_BUL

;----

DO_Y_VELS      LDA BUL_Y_VEL,X
               ADD SPRITE_Y+24,X
               STA SPRITE_Y+24,X
               CMP #$F0
               BCC NEXT_BAD_BUL
               CMP #30
               BCS NEXT_BAD_BUL
               LDA #0
               STA SPRITE_X+24,X
               STA SPRITE_Y+24,X
               STA BAD_BUL_FLAGS,X
               JMP NEXT_BAD_BUL

;-----

SET_BAD_BUL    AND #$7F
               STA BAD_BUL_FLAGS,X
               LDY FIRING_SPRITE,X
               LDA SPRITE_X+08,Y
               STA SPRITE_X+24,X
               LDA X_MSB+08,Y
               STA X_MSB+24,X
               LDA SPRITE_Y+08,Y
               STA SPRITE_Y+24,X
               LDA #$83                 ;bullet
               STA SPRITE_P+24,X
               LDA #PURPLE
               STA SPRITE_C+24,X
               JMP NEXT_BAD_BUL

;-----------------------------------------------------------------------------
;
; BIG_ANIMATE - process animation on big baddies
;

BIG_ANIMATE    LDA BIGGY_DEATH
               BEQ CAN_ANIM
               RTS

CAN_ANIM       LDA BIG_ANIM_CNT
               ADD #1
               AND #3
               STA BIG_ANIM_CNT
               BEQ DO_BIG_ANIM
               RTS

DO_BIG_ANIM    LDX #BIGGY_MAX-1
FIND_BIG_ANIM  LDA BIGGY_ANI_FLAG,X
               BNE GET_ANIM
               DEX
               BPL FIND_BIG_ANIM
               RTS

GET_ANIM       LDY BIGGY_ANI_IND,X
               LDA BIGGY_ANIM_L,X
               STA FROM
               LDA BIGGY_ANIM_H,X
               STA FROM+1
               LDA (FROM),Y
               BEQ RESET_BIG_ANI
               STA BIGGY_P,X
               INC BIGGY_ANI_IND,X
               DEX
               BPL FIND_BIG_ANIM
               RTS

RESET_BIG_ANI  LDA #0
               STA BIGGY_ANI_IND,X
               BEQ GET_ANIM             ;always

;-----------------------------------------------------------------------------
;
; BIG_COLLISIONS - Handles collision between player big baddies, and bullets
;

BIG_COLLISIONS LDA DEATH_FLAG           ;am i exploding ?
               BEQ DO_COLLIS_1
               JMP MY_BULLET_COL        ;just process my bullet collision

DO_COLLIS_1    LDA INVINCE_FLAG         ;am i invincible ?
               BEQ NOT_INVINCE
               JMP MY_BULLET_COL        ;just process my bullet collision

NOT_INVINCE    LDA BIGGY_DEATH          ;is the biggy exploding
               BEQ DO_COLLIS_2
               RTS

DO_COLLIS_2    LDA X_MSB                ;collision, player to big baddy
               LSR 
               LDA SPRITE_X
               ROR 
               STA MY_X_MOD_1B+1

               LDX BIGGY_SIZE           ;number of sprites in big baddy-1
               DEX
BIG_COL_1      LDA X_MSB+08,X           ;big baddy MSB
               LSR 
               LDA SPRITE_X+08,X        ;big baddy X
               ROR 
               STA HIS_X_MOD_1B+1
               STA HIS_X_MOD_2B+1
               LDA SPRITE_Y+08,X
               STA HIS_Y_MOD_1B+1
               STA HIS_Y_MOD_2B+1

MY_X_MOD_1B    LDA #0                   ;my x
               ADD #12
HIS_X_MOD_1B   CMP #0                   ;big baddy x
               BCC NO_COLLIDE
               SBC #24
HIS_X_MOD_2B   CMP #0                   ;big baddy x
               BCS NO_COLLIDE
               LDA SPRITE_Y             ;my y
               ADC #16
HIS_Y_MOD_1B   CMP #0                   ;big baddy y
               BCC NO_COLLIDE
               SBC #32
HIS_Y_MOD_2B   CMP #0                   ;big baddy y
               BCS NO_COLLIDE

               LDA #1                   ;I hit the big baddy
               STA DEATH_FLAG
               LDA #$5B
               STA SPRITE_P

NO_COLLIDE     DEX
               BPL BIG_COL_1
;----
MY_BULLET_COL  LDY #P1_MAX_BULS-1       ;collision, player bullets & big baddy
FIND_ON_BULS   LDA P1_BUL_FLAGS,Y
               BNE BUL_IS_ON
               DEY
               BPL FIND_ON_BULS
               RTS

BUL_IS_ON      LDX P1_BUL_X,Y
               LDA BUL_X_LOOKUP,X       ;character to sprite x lookup
               STA BUL_X_MOD_1C+1
               LDX P1_BUL_Y,Y
               LDA BUL_Y_LOOKUP,X       ;character to sprite y lookup
               STA BUL_Y_MOD_1C+1

               LDX BIGGY_SIZE
               DEX
BUL_COL_1      LDA X_MSB+08,X
               LSR 
               LDA SPRITE_X+08,X
               ROR 
               STA HIS_X_MOD_1C+1
               STA HIS_X_MOD_2C+1
               LDA SPRITE_Y+08,X
               STA HIS_Y_MOD_1C+1
               STA HIS_Y_MOD_2C+1

BUL_X_MOD_1C   LDA #0                   ;my bullet x
               ADD #4
HIS_X_MOD_1C   CMP #0                   ;big baddy x
               BCC NO_HIT_2
               SBC #8
HIS_X_MOD_2C   CMP #0                   ;big baddy x
               BCS NO_HIT_2
BUL_Y_MOD_1C   LDA #0                   ;my bullet y
               ADC #8
HIS_Y_MOD_1C   CMP #0                   ;big baddy y
               BCC NO_HIT_2
               SBC #24
HIS_Y_MOD_2C   CMP #0                   ;big baddy y
               BCS NO_HIT_2

               LDA #$80                 ;hit
               STA P1_BUL_FLAGS,Y       ;shut down bullet
               LDA SPRITE_C+08,X
               BPL NO_HIT_2             ;this isn't a destroyable sprite
               INC SPRITE_C+08,X        ;flash to indicate a hit
               DEC BIGGY_HITS,X
               BEQ BIGGY_IS_DEAD

NO_HIT_2       DEX
               BPL BUL_COL_1
               DEY
               BPL FIND_ON_BULS
               RTS

BIGGY_IS_DEAD  LDA #$81                 ;trigger the ig baddy explosion
               STA BIGGY_DEATH
               RTS

;----
;these tables convert char coordinates to sprite coordinates

BUL_X_LOOKUP   DFB 12+04                ;x coordinates are shifted down
               DFB 12+08                ;for speed
               DFB 12+12
               DFB 12+16
               DFB 12+20
               DFB 12+24
               DFB 12+28
               DFB 12+32
               DFB 12+36
               DFB 12+40
               DFB 12+44
               DFB 12+48
               DFB 12+52
               DFB 12+56
               DFB 12+60
               DFB 12+64
               DFB 12+68
               DFB 12+72
               DFB 12+76
               DFB 12+80
               DFB 12+84
               DFB 12+88
               DFB 12+92
               DFB 12+96
               DFB 12+100
               DFB 12+104
               DFB 12+108
               DFB 12+112
               DFB 12+116
               DFB 12+120
               DFB 12+124
               DFB 12+128
               DFB 12+132
               DFB 12+136
               DFB 12+140
               DFB 12+144
               DFB 12+148
               DFB 12+152
               DFB 12+156
;----
BUL_Y_LOOKUP   DFB 50+00*8
               DFB 50+01*8
               DFB 50+02*8
               DFB 50+03*8
               DFB 50+04*8
               DFB 50+05*8
               DFB 50+06*8
               DFB 50+07*8
               DFB 50+08*8
               DFB 50+09*8
               DFB 50+10*8
               DFB 50+11*8
               DFB 50+12*8
               DFB 50+13*8
               DFB 50+14*8
               DFB 50+15*8
               DFB 50+16*8
               DFB 50+17*8
               DFB 50+18*8
               DFB 50+19*8
               DFB 50+20*8
               DFB 50+21*8
               DFB 50+22*8
               DFB 50+23*8
               DFB 50+04*8

;-----------------------------------------------------------------------------
;
; BIGGY_EXPLODE - processes the big explosion when the big baddy is destroyed
;

BIGGY_EXPLODE  LDA BIGGY_DEATH
               BNE BIGGY_DEAD
               RTS

BIGGY_DEAD     BMI SET_BIG_DEATH
               LDA DEATH_COUNT
               ADD #1
               AND #3
               STA DEATH_COUNT
               BEQ NEW_PHASE_2
               RTS

NEW_PHASE_2    LDA SPRITE_P+08
               CMP #$64
               BEQ BIGGY_OVER
               LDX BIGGY_SIZE
               DEX
EXPLODE_HIM    INC SPRITE_P+08,X
               DEX
               BPL EXPLODE_HIM
               RTS

BIGGY_OVER     LDX BIGGY_SIZE
               DEX
               LDA #0
SWITCH_BIGGY   STA SPRITE_X+08,X
               STA SPRITE_Y+08,X
               DEX
               BPL SWITCH_BIGGY
               STA BIGGY_DEATH
               STA BIGGY_FLAG
               STA SCROLL_FLAG
               RTS

SET_BIG_DEATH  AND #$7F
               STA BIGGY_DEATH
               LDX BIGGY_SIZE
               DEX
               LDA #$5B
SET_BIG_EXPL   STA SPRITE_P+08,X
               DEX
               BPL SET_BIG_EXPL
               RTS

;-----------------------------------------------------------------------------
;
; BIG_BADDIES - Processes big baddy movement
;

BIG_BADDIES    LDA BIGGY_DEATH          ;is the big baddy exploding ?
               BEQ BIG_NOT_DEAD
               RTS

BIG_NOT_DEAD   DEC BIG_BAD_COUNT
               BEQ GET_BIG_VELS

DO_BIG_XV      LDA BIGGY_X_VEL
               BMI BIG_X_NVE
BIG_X_PVE      ADD BIGGY_X
               STA BIGGY_X
               BCC DO_BIG_YV
               INC BIGGY_X_MSB
               JMP DO_BIG_YV

BIG_X_NVE      EOR #$FF
               ADD #1
               STA TEMP
               LDA BIGGY_X
               SUB TEMP
               STA BIGGY_X
               BCS DO_BIG_YV
               DEC BIGGY_X_MSB

;-----

DO_BIG_YV      LDA BIGGY_Y_VEL
               ADD BIGGY_Y
               STA BIGGY_Y
               JMP SHOW_BIGGY           ;do biggy movement (with clipping)

;-----

GET_BIG_VELS   LDA BIG_BAD_PATH
               STA FROM
               LDA BIG_BAD_PATH+1
               STA FROM+1

               LDY #0
               LDA (FROM),Y
               CMP #LOOP
               BEQ BIG_LOOP
               CMP #FIRE_BUL
               BEQ SET_BIG_FIRE
               CMP #STOP_SCROLL         ;should the scroll be stopped ?
               BEQ HALT_SCROLL

               STA BIG_BAD_COUNT
               INY
               LDA (FROM),Y
               STA BIGGY_X_VEL
               INY
               LDA (FROM),Y
               STA BIGGY_Y_VEL

               LDA BIG_BAD_PATH
               ADD #3
               STA BIG_BAD_PATH
               BCC DO_BIG_XV            ;process these new velocities
               INC BIG_BAD_PATH+1
               JMP DO_BIG_XV

;----

BIG_LOOP       INY                      ;get loop point
               LDA (FROM),Y
               STA BIG_BAD_PATH
               INY
               LDA (FROM),Y
               STA BIG_BAD_PATH+1
               JMP GET_BIG_VELS

;----

HALT_SCROLL    STA SCROLL_FLAG
               INC BIG_BAD_PATH
               BNE GET_BIG_VELS
               INC BIG_BAD_PATH+1
               JMP GET_BIG_VELS

;----

SET_BIG_FIRE   LDX #BADDY_BUL_MAX-1
FIND_BIG_BUL   LDA BAD_BUL_FLAGS,X
               BEQ BAD_BUL_FREE
               DEX
               BPL FIND_BIG_BUL

EXIT_BULLS     LDA BIG_BAD_PATH
               ADD #4
               STA BIG_BAD_PATH
               BCC GET_BIG_VELS
               INC BIG_BAD_PATH+1
               JMP GET_BIG_VELS

BAD_BUL_FREE   INY
               LDA (FROM),Y
               STA FIRING_SPRITE,X      ;which sprite fires the bullet
               INY
               LDA (FROM),Y
               STA BUL_X_VEL,X
               INY
               LDA (FROM),Y
               STA BUL_Y_VEL,X
               LDA #$81
               STA BAD_BUL_FLAGS,X
               BNE EXIT_BULLS           ;always

;-----------------------------------------------------------------------------
;
; INIT_BIGGY - Builds a big baddy buffer from baddy no in (A)
;              constructs big baddy offset table
;              big baddy animation tables
;              big baddy movement table
;

INIT_BIGGY     ASL 
               TAX
               LDA BIGGY_TABLES,X       ;offset table addresses
               STA FROM
               LDA BIGGY_TABLES+1,X
               STA FROM+1
               LDA BIGGY_PATHS,X        ;path table addresses
               STA BIG_BAD_PATH
               LDA BIGGY_PATHS+1,X
               STA BIG_BAD_PATH+1
               LDA BIGGY_ANIMS,X        ;animation data addresses
               STA TO
               LDA BIGGY_ANIMS+1,X
               STA TO+1

               LDA #1                   ;biggy on
               STA BIGGY_FLAG
               LDA #85                  ;biggy master coordinates
               STA BIGGY_Y
               LDA #80
               STA BIGGY_X
               LDA #1
               STA BIGGY_X_MSB
               STA BIG_BAD_COUNT

               LDY #0
               LDX #0
               LDA (FROM),Y             ;first byte = No of sprites to build
               STA BIGGY_SIZE
BUILD_LOOP     INY
               LDA (FROM),Y
               STA BIGGY_X_OFF,X        ;biggy X offset from base coord
               INY
               LDA (FROM),Y
               STA BIGGY_Y_OFF,X        ;biggy Y offset from base coord
               INY
               LDA (FROM),Y
               STA BIGGY_P,X            ;biggy pointer
               INY
               LDA (FROM),Y
               STA BIGGY_C,X            ;biggy colour
               BMI SET_HITS
               INX
               CPX BIGGY_SIZE
               BNE BUILD_LOOP
               JMP SET_ANIMS

SET_HITS       INY
               LDA (FROM),Y             ;this part of the biggy needs to be
               STA BIGGY_HITS,X         ;hit, so store the number of hits
               INX
               CPX BIGGY_SIZE
               BNE BUILD_LOOP

SET_ANIMS      LDY #0
               LDA (TO),Y
               BEQ NO_ANIM              ;0 terminate
               STA TEMP                 ;number of animating sprites in baddy
NEXT_ANIM      INY
               LAX (TO),Y               ;sprite number to animate
               INY
               LDA (TO),Y
               STA BIGGY_ANIM_L,X       ;animation address
               INY
               LDA (TO),Y
               STA BIGGY_ANIM_H,X
               LDA #1
               STA BIGGY_ANI_FLAG,X     ;animation on flags
               STA BIGGY_ANI_IND,X      ;index into animation table
               DEC TEMP
               BNE NEXT_ANIM

               LDX #ALIENS-1
               LDA #0
1$             STA ALIEN_ON,X
               DEX
               BPL 1$

NO_ANIM        RTS

;-----------------------------------------------------------------------------
;
; SHOW_BIGGY - prints up a big baddy (table created beforehand by BUILD_BIGGY)
;              (also clips baddy on top, left & right edges)
;              (bottom edge clipping isn't used 'cos the score in the border)
;

SHOW_BIGGY     LDX BIGGY_SIZE
               LDY #0
DO_CLIPPING    LDA BIGGY_X
               ADD BIGGY_X_OFF,Y
               STA SPRITE_X+08,Y
               LDA BIGGY_X_MSB
               ADC #0
               AND #1
               STA X_MSB+08,Y

               LDA #BIG_RIGHT_CLIP
               SUB SPRITE_X+08,Y
               LDA ^BIG_RIGHT_CLIP
               SBC X_MSB+08,Y
               BCC CLIP_THIS

               LDA X_MSB+08,Y
               BNE NO_X_CLIP
               LDA SPRITE_X+08,Y
               CMP #BIG_LEFT_CLIP
               BCC CLIP_THIS

NO_X_CLIP      LDA BIGGY_Y
               ADD BIGGY_Y_OFF,Y
               CMP #BIG_TOP_CLIP
               BCC CLIP_THIS
               STA SPRITE_Y+08,Y
               LDA BIGGY_P,Y
               STA SPRITE_P+08,Y
               LDA BIGGY_C,Y
               STA SPRITE_C+08,Y
               INY
               DEX
               BNE DO_CLIPPING
               RTS

CLIP_THIS      LDA #0
               STA SPRITE_X+08,Y
               STA SPRITE_Y+08,Y
               INY
               DEX
               BNE DO_CLIPPING
               RTS

;-----------------------------------------------------------------------------
;
; DUMP_BULLETS - Prints and erases bullets onto the current screen
;

DUMP_BULLETS   LDX #P1_MAX_BULS-1
SCAN_BULLETS   LDA P1_BUL_FLAGS,X
               BNE P1_BUL_ACTIVE
               DEX
               BPL SCAN_BULLETS
               RTS

P1_BUL_ACTIVE  LDY P1_BUL_Y,X

               LDA SCRBASE
               AND #$10
               BEQ PLOT_C8

PLOT_CC        LDA CC_LOOKUP_L,Y
               STA FRONT_SCR
               LDA CC_LOOKUP_H,Y
               STA FRONT_SCR+1
               LDA C8_LOOKUP_L,Y
               STA BACK_SCR
               LDA C8_LOOKUP_H,Y
               STA BACK_SCR+1
               BNE PLOT_BULLET          ;always

PLOT_C8        LDA C8_LOOKUP_L,Y
               STA FRONT_SCR
               LDA C8_LOOKUP_H,Y
               STA FRONT_SCR+1
               LDA CC_LOOKUP_L,Y
               STA BACK_SCR
               LDA CC_LOOKUP_H,Y
               STA BACK_SCR+1

PLOT_BULLET    LDY P1_BUL_X,X
               LDA #$20                 ;wipe off front and back screen
               STA (FRONT_SCR),Y
               DEY
               STA (BACK_SCR),Y
               LDA P1_BUL_FLAGS,X       ;if the flag has Bit 7 set then the
               BMI TERMINATE_BUL        ;mainloop hs terminated the bullet
               INY
               INY
               CPY #39                  ;reached right hand boundary ?
               BEQ TERMINATE_BUL
               LDA X_FINE               ;on scroll pixel 0, so don't INC
               BEQ NO_INC               ;the bullet X position
               TYA
               STA P1_BUL_X,X
NO_INC         LDA (FRONT_SCR),Y
               CMP #$20                 ;is there a blank char here
               BEQ OK_TO_PRINT          ;yes, you can print bullet here
               CMP #4                   ;first 5 chars are bullets
               BCS TERMINATE_BUL        ;it's background so stop bullet
OK_TO_PRINT    LDA #0                   ;bullet
               STA (FRONT_SCR),Y
               DEX
               BPL SCAN_BULLETS
               RTS

TERMINATE_BUL  LDA #0
               STA P1_BUL_FLAGS,X
               DEX
               BPL SCAN_BULLETS
               RTS

;----

CC_LOOKUP_L    DFL $CC00+00*40
               DFL $CC00+01*40
               DFL $CC00+02*40
               DFL $CC00+03*40
               DFL $CC00+04*40
               DFL $CC00+05*40
               DFL $CC00+06*40
               DFL $CC00+07*40
               DFL $CC00+08*40
               DFL $CC00+09*40
               DFL $CC00+10*40
               DFL $CC00+11*40
               DFL $CC00+12*40
               DFL $CC00+13*40
               DFL $CC00+14*40
               DFL $CC00+15*40
               DFL $CC00+16*40
               DFL $CC00+17*40
               DFL $CC00+18*40
               DFL $CC00+19*40
               DFL $CC00+20*40
               DFL $CC00+21*40
               DFL $CC00+22*40
               DFL $CC00+23*40
               DFL $CC00+24*40

CC_LOOKUP_H    DFH $CC00+00*40
               DFH $CC00+01*40
               DFH $CC00+02*40
               DFH $CC00+03*40
               DFH $CC00+04*40
               DFH $CC00+05*40
               DFH $CC00+06*40
               DFH $CC00+07*40
               DFH $CC00+08*40
               DFH $CC00+09*40
               DFH $CC00+10*40
               DFH $CC00+11*40
               DFH $CC00+12*40
               DFH $CC00+13*40
               DFH $CC00+14*40
               DFH $CC00+15*40
               DFH $CC00+16*40
               DFH $CC00+17*40
               DFH $CC00+18*40
               DFH $CC00+19*40
               DFH $CC00+20*40
               DFH $CC00+21*40
               DFH $CC00+22*40
               DFH $CC00+23*40
               DFH $CC00+24*40

C8_LOOKUP_L    DFL $C800+00*40
               DFL $C800+01*40
               DFL $C800+02*40
               DFL $C800+03*40
               DFL $C800+04*40
               DFL $C800+05*40
               DFL $C800+06*40
               DFL $C800+07*40
               DFL $C800+08*40
               DFL $C800+09*40
               DFL $C800+10*40
               DFL $C800+11*40
               DFL $C800+12*40
               DFL $C800+13*40
               DFL $C800+14*40
               DFL $C800+15*40
               DFL $C800+16*40
               DFL $C800+17*40
               DFL $C800+18*40
               DFL $C800+19*40
               DFL $C800+20*40
               DFL $C800+21*40
               DFL $C800+22*40
               DFL $C800+23*40
               DFL $C800+24*40

C8_LOOKUP_H    DFH $C800+00*40
               DFH $C800+01*40
               DFH $C800+02*40
               DFH $C800+03*40
               DFH $C800+04*40
               DFH $C800+05*40
               DFH $C800+06*40
               DFH $C800+07*40
               DFH $C800+08*40
               DFH $C800+09*40
               DFH $C800+10*40
               DFH $C800+11*40
               DFH $C800+12*40
               DFH $C800+13*40
               DFH $C800+14*40
               DFH $C800+15*40
               DFH $C800+16*40
               DFH $C800+17*40
               DFH $C800+18*40
               DFH $C800+19*40
               DFH $C800+20*40
               DFH $C800+21*40
               DFH $C800+22*40
               DFH $C800+23*40
               DFH $C800+24*40

;-----------------------------------------------------------------------------
;
; BORDER_PANEL - Overscans the border and puts the panel in
;

BORDER_PANEL   LDA #$13                 ;border overscan
               STA $D011
               LDA #$20
               STA $D018

               LDA #$FE                 ;panel y coordinate
               STA $D001
               STA $D003
               STA $D005
               STA $D007
               STA $D009
               STA $D00B
               STA $D00D
               STA $D00F
               LDA #85                  ;panel x coordinate
               STA $D000
               LDA #85+24
               STA $D002
               LDA #85+48
               STA $D004
               LDA #85+72
               STA $D006
               LDA #85+96
               STA $D008
               LDA #85+120
               STA $D00A
               LDA #85+144
               STA $D00C
               LDA #85+168
               STA $D00E
               LDX #$98                 ;panel pointers
               STX $CBF8
               INX
               STX $CBF9
               INX
               STX $CBFA
               INX
               STX $CBFB
               INX
               STX $CBFC
               INX
               STX $CBFD
               INX
               STX $CBFE
               INX
               STX $CBFF
               LDA #LBLUE               ;panel colour
               STA $D027
               STA $D028
               STA $D029
               STA $D02A
               STA $D02B
               STA $D02C
               STA $D02D
               STA $D02E
               LDA #0                   ;panel msb
               STA $D010
               RTS

;-----------------------------------------------------------------------------
;
; FLIP_SCREEN - Swops which screen is being displayed
;

FLIP_SCREEN    LDA FLIP_FLAG            ;see if a flip is required
               BNE DO_FLIP
               RTS

DO_FLIP        LDA SCRBASE
               EOR #$10
               STA SCRBASE
               DEC FLIP_FLAG
               RTS

;-----------------------------------------------------------------------------
;
; SCROLL - Scrolls a portion of the screen over to the other screen
;           scrolled screen is constructed over 8 frames
;

SCROLL         LDA SCROLL_FLAG          ;is scrolling enabled
               BEQ SCROLL_ON            ;no

               LDA X_FINE               ;if we are on smooth pixel zero
               BEQ SCROLL_ON            ;scroll on 1 pixel (bullet routine
               RTS                      ;requires non zero X_FINE value

SCROLL_ON      LDA X_FINE
               SUB #1
               AND #7
               STA X_FINE
               BCS SCROLL_MAIN

SET_FLIP       INC HORPOS_L
               BNE NO_H
               INC HORPOS_H

NO_H           LDA #1                   ;indicate a screen flip
               STA FLIP_FLAG

SCROLL_MAIN    LDA SCRBASE              ;which screen we shoud be updating
               AND #$10
               BNE UPDATE_A

UPDATE_B       LDX X_FINE               ;use which scroll
               LDA C8_TO_CC_L,X
               STA SCROLL_VECT_1+1
               LDA C8_TO_CC_H,X
               STA SCROLL_VECT_1+2

SCROLL_VECT_1  JMP $AAAA                ;self modified

;-----------------------------------------------------------------------------

UPDATE_A       LDX X_FINE
               LDA CC_TO_C8_L,X
               STA SCROLL_VECT_2+1
               LDA CC_TO_C8_H,X
               STA SCROLL_VECT_2+2

SCROLL_VECT_2  JMP $AAAA                ;self modified

;-----------------------------------------------------------------------------
;scroll vectors - which scroll routine to use on each frame

C8_TO_CC_L     DFL SCROLL_01
               DFL SCROLL_02
               DFL SCROLL_03
               DFL SCROLL_04
               DFL SCROLL_05
               DFL SCROLL_06
               DFL SCROLL_07
               DFL SCROLL_08

C8_TO_CC_H     DFH SCROLL_01
               DFH SCROLL_02
               DFH SCROLL_03
               DFH SCROLL_04
               DFH SCROLL_05
               DFH SCROLL_06
               DFH SCROLL_07
               DFH SCROLL_08

CC_TO_C8_L     DFL SCROLL_09
               DFL SCROLL_10
               DFL SCROLL_11
               DFL SCROLL_12
               DFL SCROLL_13
               DFL SCROLL_14
               DFL SCROLL_15
               DFL SCROLL_16

CC_TO_C8_H     DFH SCROLL_09
               DFH SCROLL_10
               DFH SCROLL_11
               DFH SCROLL_12
               DFH SCROLL_13
               DFH SCROLL_14
               DFH SCROLL_15
               DFH SCROLL_16

;-----------------------------------------------------------------------------
;scroll routines - copying three scan lines per frame to the alternate screen
;                  routines 00-09 screen A to screen B
;                  routines 10-16 screen B to screen A
;                  routines 08 and 16 decode a new map segment

SCROLL_01      LDX #39
LOOP_01        LDA $C801+00*40,X
               STA $CC00+00*40,X
               LDA $C801+01*40,X
               STA $CC00+01*40,X
               LDA $C801+02*40,X
               STA $CC00+02*40,X
               DEX
               BPL LOOP_01
               RTS

SCROLL_02      LDX #39
LOOP_02        LDA $C801+03*40,X
               STA $CC00+03*40,X
               LDA $C801+04*40,X
               STA $CC00+04*40,X
               LDA $C801+05*40,X
               STA $CC00+05*40,X
               DEX
               BPL LOOP_02
               RTS

SCROLL_03      LDX #39
LOOP_03        LDA $C801+06*40,X
               STA $CC00+06*40,X
               LDA $C801+07*40,X
               STA $CC00+07*40,X
               LDA $C801+08*40,X
               STA $CC00+08*40,X
               DEX
               BPL LOOP_03
               RTS

SCROLL_04      LDX #39
LOOP_04        LDA $C801+09*40,X
               STA $CC00+09*40,X
               LDA $C801+10*40,X
               STA $CC00+10*40,X
               LDA $C801+11*40,X
               STA $CC00+11*40,X
               DEX
               BPL LOOP_04
               RTS

SCROLL_05      LDX #39
LOOP_05        LDA $C801+12*40,X
               STA $CC00+12*40,X
               LDA $C801+13*40,X
               STA $CC00+13*40,X
               LDA $C801+14*40,X
               STA $CC00+14*40,X
               DEX
               BPL LOOP_05
               RTS

SCROLL_06      LDX #39
LOOP_06        LDA $C801+15*40,X
               STA $CC00+15*40,X
               LDA $C801+16*40,X
               STA $CC00+16*40,X
               LDA $C801+17*40,X
               STA $CC00+17*40,X
               DEX
               BPL LOOP_06
               RTS

SCROLL_07      LDX #39
LOOP_07        LDA $C801+18*40,X
               STA $CC00+18*40,X
               LDA $C801+19*40,X
               STA $CC00+19*40,X
               LDA $C801+20*40,X
               STA $CC00+20*40,X
               DEX
               BPL LOOP_07
               RTS

SCROLL_08      LDX #39
LOOP_08        LDA $C801+21*40,X
               STA $CC00+21*40,X
               LDA $C801+22*40,X
               STA $CC00+22*40,X
               LDA $C801+23*40,X
               STA $CC00+23*40,X
               DEX
               BPL LOOP_08

               LDA #$CC00+39
               STA SCR_ADD+1
               LDA ^$CC00+39
               STA SCR_ADD+2
               JMP DECODE

;-----------------------------------

SCROLL_09      LDX #39
LOOP_09        LDA $CC01+00*40,X
               STA $C800+00*40,X
               LDA $CC01+01*40,X
               STA $C800+01*40,X
               LDA $CC01+02*40,X
               STA $C800+02*40,X
               DEX
               BPL LOOP_09
               RTS

SCROLL_10      LDX #39
LOOP_10        LDA $CC01+03*40,X
               STA $C800+03*40,X
               LDA $CC01+04*40,X
               STA $C800+04*40,X
               LDA $CC01+05*40,X
               STA $C800+05*40,X
               DEX
               BPL LOOP_10
               RTS

SCROLL_11      LDX #39
LOOP_11        LDA $CC01+06*40,X
               STA $C800+06*40,X
               LDA $CC01+07*40,X
               STA $C800+07*40,X
               LDA $CC01+08*40,X
               STA $C800+08*40,X
               DEX
               BPL LOOP_11
               RTS

SCROLL_12      LDX #39
LOOP_12        LDA $CC01+09*40,X
               STA $C800+09*40,X
               LDA $CC01+10*40,X
               STA $C800+10*40,X
               LDA $CC01+11*40,X
               STA $C800+11*40,X
               DEX
               BPL LOOP_12
               RTS

SCROLL_13      LDX #39
LOOP_13        LDA $CC01+12*40,X
               STA $C800+12*40,X
               LDA $CC01+13*40,X
               STA $C800+13*40,X
               LDA $CC01+14*40,X
               STA $C800+14*40,X
               DEX
               BPL LOOP_13
               RTS

SCROLL_14      LDX #39
LOOP_14        LDA $CC01+15*40,X
               STA $C800+15*40,X
               LDA $CC01+16*40,X
               STA $C800+16*40,X
               LDA $CC01+17*40,X
               STA $C800+17*40,X
               DEX
               BPL LOOP_14
               RTS

SCROLL_15      LDX #39
LOOP_15        LDA $CC01+18*40,X
               STA $C800+18*40,X
               LDA $CC01+19*40,X
               STA $C800+19*40,X
               LDA $CC01+20*40,X
               STA $C800+20*40,X
               DEX
               BPL LOOP_15
               RTS

SCROLL_16      LDX #39
LOOP_16        LDA $CC01+21*40,X
               STA $C800+21*40,X
               LDA $CC01+22*40,X
               STA $C800+22*40,X
               LDA $CC01+23*40,X
               STA $C800+23*40,X
               DEX
               BPL LOOP_16

               LDA #$C800+39
               STA SCR_ADD+1
               LDA ^$C800+39
               STA SCR_ADD+2
               JMP DECODE

;-----------------------------------------------------------------------------
;
; DECODE - Decodes a new map segment to the right hand edge
;

DECODE         LDA HORPOS_H             ;store high byte for calculation
               STA CALC+1

               LDA HORPOS_L             ;mask off low 3 bits
; AND #$FC                 ;to get horpos to the nearest 4 bytes

               LSR CALC+1               ;divide by 4
               ROR 
               LSR CALC+1
               ROR 

               ASL                      ;times number by 6
               ROL CALC+1               ;(number of vertical blocks)
               STA TEMP
               LDA CALC+1
               STA TEMP+1
               LDA TEMP
               ASL 
               ROL CALC+1
               ADD TEMP
               ADC #MAP_START           ;plus map base address
               STA MAP
               LDA CALC+1
               ADC TEMP+1
               ADC ^MAP_START
               STA MAP+1

               LDA HORPOS_L             ;depth is the horizontal depth
               AND #3                   ;within the block
               STA DEPTH_MOD_1+1

               LDA #6                   ;6 blocks deep
               STA BLOCK_DEPTH

NEXT_BLOCK     LDY #0
               LAX (MAP),Y              ;block number times 16
               LDA TIMES_16_L,X
               ADD #BLOCK_START         ;plus block base address
               STA BLOCK
               LDA TIMES_16_H,X
               ADC ^BLOCK_START
               STA BLOCK+1

               LDX #3                   ;each block is 4 characters deep
DEPTH_MOD_1    LDY #0                   ;modified depth within the block
DUMP_BLOCK     LDA (BLOCK),Y
SCR_ADD        STA $AAAA                ;self modified screen address
               INY
               INY                      ;increment the depth index by 4
               INY                      ;for next vertical char within block
               INY
               LDA SCR_ADD+1            ;next vertical screen line
               ADD #40
               STA SCR_ADD+1
               BCC SKIP_IT
               INC SCR_ADD+2
SKIP_IT        DEX
               BPL DUMP_BLOCK

               INC MAP                  ;next block
               BNE SKIP_IT_2
               INC MAP+1

SKIP_IT_2      DEC BLOCK_DEPTH          ;see if full row has been dumped
               BNE NEXT_BLOCK

               RTS

;-----------------------------------------------------------------------------
;
; TIMES_16 - Pre calculated table of values *16
;

TIMES_16_L     DFS 256,0
TIMES_16_H     DFS 256,0

;-----------------------------------------------------------------------------
;
; SETRAST - Initialise raster interrupts
;

SETRAST        SEI
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF

               LDA #FIRST_RAST
               STA $D012

               LDA #$7F
               AND $D011
               STA $D011
               STA $DC0D
               STA $DD0D
               LDA $DC0D
               LDA $DD0D

               LDX #1
               STX $D019
               STX $D01A

               CLI
               RTS

;-----------------------------------------------------------------------------
;
; SETBANK - Initialises video base address
;

SETBANK        LDA #$C0                 ;bank 3 ($C000)
               STA $DD00
               LDA #%00100000           ;charset $C000, screen $C800
               STA $D018
               RTS

;-----------------------------------------------------------------------------
;
; VAR_CLOBBER - !!!!
;

VAR_CLOBBER    LDX #2                   ;this fixes a pain-in-the-arse
               LDA #0                   ;bug courtesy of good old XDEV v2
CLR_ZP         STA 0,X
               INX
               BNE CLR_ZP
CLR_VARS       STA $0200,X              ;wack the variable area with zeroes
               STA $0300,X
               STA $0400,X
               INX
               BNE CLR_VARS
               RTS

;-----------------------------------------------------------------------------
;
; SETUP - Initialises the multiplexor
;

SETUP          LDY #NSP-1
SET1           TYA
               STA POINTER,Y            ;clear pointers in decending order
               LDA #0
               STA SPRITE_X,Y           ;clear multiplexor variables
               STA SX,Y
               STA SPRITE_Y,Y
               STA SY2,Y
               STA SPRITE_C,Y
               AND #$0F
               TAX
               LDA #0
               STA $D000,X              ;and VIC variables
               DEY
               BPL SET1
               STY $D015                ;sprites on
               INY
               STY $D010                ;MSB clear

               JMP GENLIST              ;generate sprite order list

;-----------------------------------------------------------------------------
;
; WARM_START - Initialises initial player positions, databases etc....
;

WARM_START     LDX #$FF                 ;sprite multicolour enable
               STX $D01C
               INX
               STX $D020
               STX $D021
               LDA #$1B                 ;screen on, y centered
               STA $D011
               LDA #$D8                 ;reset screen X
               STA $D016

               LDA #7
               STA X_FINE               ;reset smooth x counters
               STA X_FINE_2

               LDA #WHITE               ;sprite multicolours
               STA $D025
               LDA #DGREY
               STA $D026

               LDA #BLACK+8
               JSR CLEAR_SCREENS        ;clear physical & logical screens

               LDA #$30
               STA SPRITE_X
               LDA #$90
               STA SPRITE_Y
               LDA #$43
               STA SPRITE_P
               LDA #LBLUE
               STA SPRITE_C

               LDA #1                   ;character multi colours
               STA $D022
               LDA #14
               STA $D023

               LDA #TEST_DATA           ;attack pattern database
               STA DATA_BASE
               LDA ^TEST_DATA
               STA DATA_BASE+1
               RTS

;-----------------------------------------------------------------------------
;
; GEN_TIMES_16 -
;

GEN_TIMES_16   LDX #0
NEXT_VALUE     LDA #0
               STA CALC
               TXA
               ASL 
               ROL CALC
               ASL 
               ROL CALC
               ASL 
               ROL CALC
               ASL 
               ROL CALC
               STA TIMES_16_L,X
               LDA CALC
               STA TIMES_16_H,X
               INX
               BNE NEXT_VALUE
               RTS

;-----------------------------------------------------------------------------
;
; R1 - Second raster, base of the screen
;      Handles multiplexor sort
;


R1             STA IA                   ;preserve current registers
               STX IX
               STY IY
               CLD                      ;clear decimal mode
               DEC $D019                ;acknowledge the interrupt

               IFL SHOW_RASTER=TRUE
               LDA #BLUE
               STA $D020
               ENDF

               JSR BORDER_PANEL

               IFL SHOW_RASTER=TRUE
               LDA #DGREY
               STA $D020
               ENDF

               JSR DUMP_BULLETS         ;dump out charcter bullets

               IFL SHOW_RASTER=TRUE
               LDA #RED
               STA $D020
               ENDF

               JSR GENLIST              ;sort sprite display order

               IFL SHOW_RASTER=TRUE
               LDA #PURPLE
               STA $D020
               ENDF

               JSR DUMP_SPRITES         ;copy over the sprite buffers
               JSR CLRVIC               ;clear last vic images

               LDA #$1B                 ;switch overscan off
               STA $D011

               INC LASTCOUNT            ;mainloop synchroniser

               LDA #$50                 ;insert X fine scroll
               ORA X_FINE_2
               STA $D016

               LDA #$00                 ;insert screen base address
               ORA SCRBASE
               STA $D018

               IFL SHOW_RASTER=TRUE
               LDA #BLACK
               STA $D020
               ENDF

               LDA #PLEX                ;point next interrupt to multiplexor
               STA $FFFE
               LDA ^PLEX
               STA $FFFF
;   LDA $D012
;  ADD #1
               LDA #$20
               STA $D012

;         JMP DROP_IN              ;drop into the plex routine

               LDA IA                   ;regain registers
               LDX IX
               LDY IY

               RTI                      ;interrupt exit

;-----------------------------------------------------------------------------
;
; PLEX - Self generating raster dumps sprites onto the screen
;

PLEX           STA IA
               STX IX
               STY IY
               CLD
               DEC $D019

DROP_IN
               IFL SHOW_RASTER=TRUE
               INC $D020
               ENDF

               LDA $D012
               ADD #RASTDIF             ; Generate the maximum split time
               STA RASTEMP

RAST3          LDX NXTSPR               ; Which VIC sprite to use
               LDA SPRITE_TABLE_L,X
               STA SPRITE_JUMP+1
               LDA SPRITE_TABLE_H,X     ; Which routine to go to
               STA SPRITE_JUMP+2

SPRITE_JUMP    JMP $FFFF                ; Self modified sprite JUMP address

;-----------------------------------------------------------------------------
;8 sprite dump routines

SPRITE_1       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY                  ; VIC Y
               CMP RASTEMP
               BCS RASTEND_1            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX                  ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR
               LDA SPRITE_P,X           ; and the pointers
               STA $CBF8
               STA $CFF8
               LDA X_MSB_2,X
               BEQ MASKMSB_1

SETMSB_1       LDA $D010                ; Set the MSB
               ORA #1
               STA $D010
               BNE NEXTSPRITE_1         ; Always

MASKMSB_1      LDA $D010                ; Clear the MSB
               AND #$FE
               STA $D010

NEXTSPRITE_1   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_1
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_1
               JMP RAST3
RESET_1        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_1      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_1

RASTEND_1      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_1
               BCS XIT2_1

               LDA $D012
XIT1_1         ADD #2
XIT2_1         ADC #1
               STA $D012

OUT1_1
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_2       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+2                ; VIC Y
               CMP RASTEMP
               BCS RASTEND_2            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+2                ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+1
               LDA SPRITE_P,X           ; and the pointers
               STA $CBF9
               STA $CFF9
               LDA X_MSB_2,X
               BEQ MASKMSB_2

SETMSB_2       LDA $D010                ; Set the MSB
               ORA #2
               STA $D010
               BNE NEXTSPRITE_2         ; Always

MASKMSB_2      LDA $D010                ; Clear the MSB
               AND #$FD
               STA $D010

NEXTSPRITE_2   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_2
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_2
               JMP RAST3
RESET_2        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_2      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_2

RASTEND_2      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_2
               BCS XIT2_2

               LDA $D012
XIT1_2         ADD #2
XIT2_2         ADC #1
               STA $D012

OUT1_2
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_3       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+4                ; VIC Y
               CMP RASTEMP
               BCS RASTEND_3            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+4                ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+2
               LDA SPRITE_P,X           ; and the pointers
               STA $CBFA
               STA $CFFA
               LDA X_MSB_2,X
               BEQ MASKMSB_3

SETMSB_3       LDA $D010                ; Set the MSB
               ORA #4
               STA $D010
               BNE NEXTSPRITE_3         ; Always

MASKMSB_3      LDA $D010                ; Clear the MSB
               AND #$FB
               STA $D010

NEXTSPRITE_3   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_3
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_3
               JMP RAST3
RESET_3        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_3      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_2

RASTEND_3      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_3
               BCS XIT2_3

               LDA $D012
XIT1_3         ADD #2
XIT2_3         ADC #1
               STA $D012

OUT1_3
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_4       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+6                ; VIC Y
               CMP RASTEMP
               BCS RASTEND_4            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+6                ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+3
               LDA SPRITE_P,X           ; and the pointers
               STA $CBFB
               STA $CFFB
               LDA X_MSB_2,X
               BEQ MASKMSB_4

SETMSB_4       LDA $D010                ; Set the MSB
               ORA #8
               STA $D010
               BNE NEXTSPRITE_4         ; Always

MASKMSB_4      LDA $D010                ; Clear the MSB
               AND #$F7
               STA $D010

NEXTSPRITE_4   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_4
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_4
               JMP RAST3
RESET_4        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_4      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_4

RASTEND_4      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_4
               BCS XIT2_4

               LDA $D012
XIT1_4         ADD #2
XIT2_4         ADC #1
               STA $D012

OUT1_4
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_5       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+8                ; VIC Y
               CMP RASTEMP
               BCS RASTEND_5            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+8                ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+4
               LDA SPRITE_P,X           ; and the pointers
               STA $CBFC
               STA $CFFC
               LDA X_MSB_2,X
               BEQ MASKMSB_5

SETMSB_5       LDA $D010                ; Set the MSB
               ORA #16
               STA $D010
               BNE NEXTSPRITE_5         ; Always

MASKMSB_5      LDA $D010                ; Clear the MSB
               AND #$EF
               STA $D010

NEXTSPRITE_5   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_5
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_5
               JMP RAST3
RESET_5        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_5      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_2

RASTEND_5      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_5
               BCS XIT2_5

               LDA $D012
XIT1_5         ADD #2
XIT2_5         ADC #1
               STA $D012

OUT1_5
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_6       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+10               ; VIC Y
               CMP RASTEMP
               BCS RASTEND_6            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+10               ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+5
               LDA SPRITE_P,X           ; and the pointers
               STA $CBFD
               STA $CFFD
               LDA X_MSB_2,X
               BEQ MASKMSB_6

SETMSB_6       LDA $D010                ; Set the MSB
               ORA #32
               STA $D010
               BNE NEXTSPRITE_6         ; Always

MASKMSB_6      LDA $D010                ; Clear the MSB
               AND #$DF
               STA $D010

NEXTSPRITE_6   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_6
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_6
               JMP RAST3
RESET_6        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_6      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_2

RASTEND_6      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_6
               BCS XIT2_6

               LDA $D012
XIT1_6         ADD #2
XIT2_6         ADC #1
               STA $D012

OUT1_6
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_7       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+12               ; VIC Y
               CMP RASTEMP
               BCS RASTEND_7            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+12               ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+6
               LDA SPRITE_P,X           ; and the pointers
               STA $CBFE
               STA $CFFE
               LDA X_MSB_2,X
               BEQ MASKMSB_7

SETMSB_7       LDA $D010                ; Set the MSB
               ORA #64
               STA $D010
               BNE NEXTSPRITE_7         ; Always

MASKMSB_7      LDA $D010                ; Clear the MSB
               AND #$BF
               STA $D010

NEXTSPRITE_7   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_7
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_7
               JMP RAST3
RESET_7        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_7      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_7

RASTEND_7      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_7
               BCS XIT2_7

               LDA $D012
XIT1_7         ADD #2
XIT2_7         ADC #1
               STA $D012

OUT1_7
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------

SPRITE_8       LDY NXTSP                ; Get the next multiplexed pointer
               LDX POINTER,Y
               LDA SY2,X                ; Multiplexor Y
               STA SPY+14               ; VIC Y
               CMP RASTEMP
               BCS RASTEND_8            ; Over the maximum time ... Exit
               LDA SX,X
               STA SPX+14               ; Put the X into the VIC chip
               LDA SPRITE_C,X           ; Put the colour into the VIC chip
               STA VIC_COLOUR+7
               LDA SPRITE_P,X           ; and the pointers
               STA $CBFF
               STA $CFFF
               LDA X_MSB_2,X
               BEQ MASKMSB_8

SETMSB_8       LDA $D010                ; Set the MSB
               ORA #128
               STA $D010
               BNE NEXTSPRITE_8         ; Always

MASKMSB_8      LDA $D010                ; Clear the MSB
               AND #$7F
               STA $D010

NEXTSPRITE_8   DEC NXTSP                ; Do the next multiplexed sprite
               BMI DONEALL_8
               DEC NXTSPR               ; And the next VIC sprite
               BMI RESET_8
               JMP RAST3
RESET_8        LDA #7                   ; Reset the VIC sprite number
               STA NXTSPR
               JMP RAST3

DONEALL_8      LDA #7
               STA NXTSPR
               LDA #FIRST_RAST          ; Next raster position
               STA $D012
               LDA #R1
               STA $FFFE
               LDA ^R1
               STA $FFFF
               JMP OUT1_8

RASTEND_8      SBC #RASTDIF             ; Work out the next split position
               CMP $D012
               BEQ XIT1_8
               BCS XIT2_8

               LDA $D012
XIT1_8         ADD #2
XIT2_8         ADC #1
               STA $D012

OUT1_8
               IFL SHOW_RASTER=TRUE
               DEC $D020
               ENDF

               LDA IA
               LDX IX
               LDY IY
               RTI

;-----------------------------------------------------------------------------
; Sprite routine address tables


SPRITE_TABLE_L DFL SPRITE_1
               DFL SPRITE_2             ; Addresses of each sprite routine
               DFL SPRITE_3
               DFL SPRITE_4
               DFL SPRITE_5
               DFL SPRITE_6
               DFL SPRITE_7
               DFL SPRITE_8

SPRITE_TABLE_H DFH SPRITE_1
               DFH SPRITE_2
               DFH SPRITE_3
               DFH SPRITE_4
               DFH SPRITE_5
               DFH SPRITE_6
               DFH SPRITE_7
               DFH SPRITE_8

;-----------------------------------------------------------------------------
;
; FX_19 - Waits for a frame flayback
;

FX_19          LDA LASTCOUNT            ; Wait for a change in LASTCOUNT
               CMP LASTVAL
               BEQ FX_19
               STA LASTVAL
               RTS

;-----------------------------------------------------------------------------
;
; WAIT - Wait for the number of flybacks in (X)
;

WAIT           JSR FX_19
               DEX
               BNE WAIT
               RTS

;-----------------------------------------------------------------------------
;
; GENLIST - Generates multiplexor sprite Y order
;

GENLIST        LDX #1
SORT           LDY POINTER-1,X
               LDA SPRITE_Y,Y
               LDY POINTER,X
               CMP SPRITE_Y,Y
               BCS IS_IN_ORDER
               LDA SPRITE_Y,Y
               STY TEMP_Y_MOD_1+1
               STX TX
               DEX
INSERT_SEARCH  DEX
               BMI FOUND_POINT
               LDY POINTER,X
               CMP SPRITE_Y,Y
               BEQ FOUND_POINT
               BCS INSERT_SEARCH
FOUND_POINT    INX
               STX CNT_MOD_1+1
               LDX TX
SHIFT_POINTER  LDA POINTER-1,X
               STA POINTER,X
               DEX
CNT_MOD_1      CPX #0                   ;modified
               BNE SHIFT_POINTER
TEMP_Y_MOD_1   LDA #0                   ;modified
               STA POINTER,X
               LDX TX
IS_IN_ORDER    INX
               CPX #NSP
               BNE SORT
               RTS

;--

DUMP_SPRITES   LDY #NSP-1               ;find first sprite with a non-zero
FINDFIRST      LDX POINTER,Y
               LDA SPRITE_Y,X           ;sprite Y value
               BNE FOUNDFIRST
               DEY
               BPL FINDFIRST
               LDY #0
FOUNDFIRST     STY NXTSP

               LDX #NSP-1               ;copy the buffered sprite coordinates
COPYBUFFER     LDA SPRITE_X,X
               STA SX,X                 ;into the used coordinate buffers
               LDA SPRITE_Y,X
               STA SY2,X
               LDA X_MSB,X
               STA X_MSB_2,X
               DEX
               BPL COPYBUFFER
               RTS

;-----------------------------------------------------------------------------
;
; CLRVIC - Clears the VIC chip
;

CLRVIC         LDX #15                  ;clear the VIC chip
               LDA #0
CLRIT          STA $D000,X
               DEX
               BPL CLRIT
               RTS

;-----------------------------------------------------------------------------
;
; KEYSCAN - Key entered in A, carry SET if key is pressed
;

KEYSCAN        STY GOT_KEY+1            ;preserve Y
               PHA
               LSR 
               LSR 
               LSR 
               TAY
               LDA COLUMN,Y
               STA $DC00
               PLA
               AND #7
               TAY
               LDA $DC01
               AND ROW,Y
               BNE NOT_PRESSED
               LDA #$FF
               STA $DC00
               LDA $DC01
               AND ROW,Y
               BEQ NOT_PRESSED
               SEC
               BCS GOT_KEY              ;always
NOT_PRESSED    CLC
GOT_KEY        LDY #0                   ;modified
               LDA #$FF
               STA $DC00
               LDA #$7F
               STA $DC01
               RTS

COLUMN         DFX FEFDFBF7EFDFBF7F
ROW            DFX 0102040810204080

;-----------------------------------------------------------------------------
;big baddy construction tables...
;
; first BYTE = number of sprites to construct big baddy from, then....
; x offset from base coord, y offset from base coord, pointer, colour(+bit7)
; (bit 7 of the colour byte indicates that this sprite needs to be hit)
; If bit 7 set then another byte follows with the number of hits required
;
;animation data tables...
;
; first BYTE = number of animated sprites, followed by
; BYTE sprite number to animate, WORD animation table address
;

BIGGY_TABLES   DFW BIGGY_OFF_1
BIGGY_ANIMS    DFW BIGGY_ANIM_1
;----

BIGGY_OFF_1    DFB 15
               DFL +000,+000,$47,LBLUE
               DFL +024,+000,$48,LBLUE
               DFL +048,+000,$49,LBLUE
               DFL +048,+021,$53,LBLUE
               DFL +072,+021,$54,LBLUE
               DFL +072,+042,$55,LBLUE
               DFL +096,+042,$56,LBLUE
               DFL +072,+063,$57,LBLUE
               DFL +096,+063,$58,LBLUE
               DFL +048,+084,$59,LBLUE
               DFL +072,+084,$5A,LBLUE
               DFL +000,+105,$4F,LBLUE
               DFL +024,+105,$50,LBLUE
               DFL +048,+105,$51,LBLUE
               DFL +058,+052,$4A,RED+$80,40
;
BIGGY_ANIM_1   DFB 1
               DFB $0E:DFW ANIM_TAB_1
;
ANIM_TAB_1     DFX 4A4B4C4D4D4C4B4A00

;-----------------------------------------------------------------------------
;big baddy movement tables
;
; counter, x velocity, y velocity
; or
; FIRE_BUL, firing sprite no, x velocity, y velocity
;

BIGGY_PATHS    DFW BIG_BAD_PATH_1

;----

BIG_BAD_PATH_1 DFL 124,-01,+00
               DFL STOP_SCROLL
BIG_1_LOOP     DFL 020,+00,-02
               DFL 040,+00,+02
               DFL 020,+00,-02

               DFL FIRE_BUL,$00,-05,+00
               DFL FIRE_BUL,$0B,-05,-00
               DFL 020,-02,-01
               DFL FIRE_BUL,$03,-05,+00
               DFL FIRE_BUL,$09,-05,-00
               DFL 020,-02,+01
               DFL 020,-02,-01
               DFL 020,-02,+01
               DFL 020,-02,-01
               DFL 020,-02,+01

               DFL 020,+02,-01
               DFL 020,+02,+01
               DFL 020,+02,-01
               DFL 020,+02,+01
               DFL 020,+02,-01
               DFL 020,+02,+01
               DFL LOOP:DFW BIG_1_LOOP

;-----------------------------------------------------------------------------
;attack path data for normal aliens

TEST_DATA      DFW 0000,FORM_01
               DFW 0049,FORM_02         ;big baddy
               DFW 4201,FORM_01

;----
;formation data, if number of aliens = 0 then trigger the big baddy whose
;number follows on e.g. DFB 00,01 = trigger big baddy 01

FORM_01        DFB 07                   ;number of aliens in this formation

               DFB 0                    ;introduce time
               DFB 80                   ;Y coordinate
               DFB RED                  ;colour
               DFW PATH_01              ;flight path
               DFW ANIM_01              ;animation table
               DFB 10                   ;shots to kill

               DFB 30                   ;introduce time
               DFB 80                   ;Y coordinate
               DFB BLUE                 ;colour
               DFW PATH_01              ;flight path
               DFW ANIM_02              ;animation table
               DFB 10                   ;shots to kill

               DFB 60                   ;introduce time
               DFB 80                   ;Y coordinate
               DFB GREEN                ;colour
               DFW PATH_01              ;flight path
               DFW ANIM_01              ;animation table
               DFB 10                   ;shots to kill

               DFB 00                   ;introduce time
               DFB 130                  ;Y coordinate
               DFB GREEN                ;colour
               DFW PATH_02              ;flight path
               DFW ANIM_01              ;animation table
               DFB 10                   ;shots to kill

               DFB 0                    ;introduce time
               DFB 210                  ;Y coordinate
               DFB PURPLE               ;colour
               DFW PATH_01              ;flight path
               DFW ANIM_03              ;animation table
               DFB 10                   ;shots to kill

               DFB 30                   ;introduce time
               DFB 210                  ;Y coordinate
               DFB LBLUE                ;colour
               DFW PATH_01              ;flight path
               DFW ANIM_04              ;animation table
               DFB 10                   ;shots to kill

               DFB 60                   ;introduce time
               DFB 210                  ;Y coordinate
               DFB PINK                 ;colour
               DFW PATH_01              ;flight path
               DFW ANIM_03              ;animation table
               DFB 10                   ;shots to kill

;----

FORM_02        DFB 00,00                ;big baddy 00


;----

ANIM_01        DFX 65666768696A6B6C00
ANIM_02        DFX 6D6E6F707172737400
ANIM_03        DFX 75767778797A7B7A7978777600
ANIM_04        DFX 7C7D7E7F80818281807F7E7D00

;----

PATH_01        DFL 20,-01,-01
               DFL 20,-01,+01
               DFL LOOP:DFW PATH_01

PATH_02        DFL 50,-02,+00
               DFL 40,-01,-01
               DFL 40,-01,+01
               DFL 40,+01,+01
               DFL 40,+01,-01
               DFL 200,-02,+00
               DFL 0

;-----------------------------------------------------------------------------

BLOCK_START

               DFB "    "
               DFB "    "
               DFB "    "
               DFB "    "

               DFB "EEEE"
               DFB "EEEE"
               DFB "EEEE"
               DFB "EEEE"

               DFB "FFFF"
               DFB "FFFF"
               DFB "FFFF"
               DFB "FFFF"


MAP_START      DFB 0,0,0,0,0,0
               DFB 0,0,0,0,0,0
               DFB 0,1,0,0,1,0
               DFB 0,0,0,0,1,0
               DFB 1,0,0,0,1,0
               DFB 0,0,0,0,0,0
               DFB 0,0,0,0,0,0
               DFB 0,1,0,0,1,0
               DFB 0,1,0,0,1,0
               DFB 0,0,0,0,0,0
               DFB 0,0,0,0,0,0
               DFB 1,0,1,0,0,0
               DFB 1,0,1,0,0,1
               DFB 0,0,1,0,0,1
               DFB 0,0,0,0,0,1
               DFB 0,0,0,1,0,0
               DFB 0,0,0,1,0,0
               DFB 0,0,0,0,0,0
               DFB 0,0,0,0,0,0

;-----------------------------------------------------------------------------
;the charcter set

               ORG $C000

               DFX 3C425A525A423C003C666676
               DFX 666666007C66667C66666C001C366660
               DFX 66663C00786C666666067C003E60606C
               DFX 60606E003E60606C606060003C66606E
               DFX 66361C0066666676666666003C001818
               DFX 18183C007E00060666361C0066666C68
               DFX 6C6666006060606060603E00367F6B63
               DFX 63636300337B6F67636363001C366666
               DFX 66603C003C66666C606060003C666666
               DFX 66301E003C66666C6C6666003C66603C
               DFX 06663C007E0018181818180066666666
               DFX 66063C0066666666666C380063636363
               DFX 6B7F36006666463C6266660066666636
               DFX 060C78007E000C1830607E00FFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF00FF000000000000FFFFFFFF
               DFX FFFFFFFF000000000000000000080808
               DFX 0808080801627F3F0E07060701010080
               DFX 00B000C0C090101010101010FFFFFFFF
               DFX FFFFFFFF386C68305A6C360018183000
               DFX 00000000080808080F00000003020300
               DFX FC000000181818383B08081810101010
               DFX F00000000000000018081000FFFFFFFF
               DFX FFFFFFFF0000000018180000FFFFFFFF
               DFX FFFFFFFF3C666E7E76663C0030181818
               DFX 18183C007C060C1830606E006C06060C
               DFX 06066C00206060686E0808003E60602C
               DFX 06663C001C30607C66663C007E00040C
               DFX 183060003C66663466663C003C66663E
               DFX 060C18000018000000180000FFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF3C3C42425A5A52525A5A4242
               DFX 3C3C00003C3C66666666767666666666
               DFX 666600007C7C666666667C7C66666666
               DFX 6C6C00001C1C36366666606066666666
               DFX 3C3C000078786C6C6666666666660606
               DFX 7C7C00003E3E606060606C6C60606060
               DFX 6E6E00003E3E606060606C6C60606060
               DFX 606000003C3C666660606E6E66663636
               DFX 1C1C0000666666666666767666666666
               DFX 666600003C3C00001818181818181818
               DFX 3C3C00007E7E00000606060666663636
               DFX 1C1C0000666666666C6C68686C6C6666
               DFX 66660000606060606060606060606060
               DFX 3E3E000036367F7F6B6B636363636363
               DFX 6363000033337B7B6F6F676763636363
               DFX 636300001C1C36366666666666666060
               DFX 3C3C00003C3C666666666C6C60606060
               DFX 606000003C3C66666666666666663030
               DFX 1E1E00003C3C666666666C6C6C6C6666
               DFX 666600003C3C666660603C3C06066666
               DFX 3C3C00007E7E00001818181818181818
               DFX 18180000666666666666666666660606
               DFX 3C3C0000666666666666666666666C6C
               DFX 3838000063636363636363636B6B7F7F
               DFX 363600006666666646463C3C62626666
               DFX 66660000666666666666363606060C0C
               DFX 787800007E7E00000C0C181830306060
               DFX 7E7E0000FFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF0000FFFF0000000000000000
               DFX 00000000FFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF000000000000000000000000
               DFX 00000000000008080808080808080808
               DFX 08080808010162627F7F3F3F0E0E0707
               DFX 0606070701010101000080800000B0B0
               DFX 0000C0C0C0C090901010101010101010
               DFX 10101010FFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF38386C6C686830305A5A6C6C
               DFX 36360000181818183030000000000000
               DFX 0000000008080808080808080F0F0000
               DFX 000000000303020203030000FCFC0000
               DFX 0000000018181818181838383B3B0808
               DFX 080818181010101010101010F0F00000
               DFX 00000000000000000000000018180808
               DFX 10100000FFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF000000000000000018181818
               DFX 00000000FFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF3C3C66666E6E7E7E76766666
               DFX 3C3C0000303018181818181818181818
               DFX 3C3C00007C7C06060C0C181830306060
               DFX 6E6E00006C6C060606060C0C06060606
               DFX 6C6C000020206060606068686E6E0808
               DFX 080800003E3E606060602C2C06066666
               DFX 3C3C00001C1C303060607C7C66666666
               DFX 3C3C00007E7E000004040C0C18183030
               DFX 606000003C3C66666666343466666666
               DFX 3C3C00003C3C666666663E3E06060C0C
               DFX 18180000000018180000000000001818
               DFX 00000000FFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
               DFX FFFFFFFF202020202020202053504543
               DFX 49414C605448414E4B5360544F7A2020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 202020202020202020202020208D8192
               DFX 94898EA097818C8B8592A0060F122005
               DFX 1814050E130916052006050504020103
               DFX 0B2C202020100C011914051314090E07
               DFX 20010E04200D0F12010C20131510100F
               DFX 12142E20202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020208C85858E81A0A6A0908594
               DFX 8592A0060F122014080520151305200F
               DFX 062014080520080F1513052020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020209081958CA0838F8F908592
               DFX A0060F122014080520051814050E0405
               DFX 0420040501040C090E05132020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202020202020
               DFX 20202020202020202020202000000001
               DFX 00000000000000020000000000000004
               DFX 00000000000000080000000000000010
               DFX 00000000000000200000000000000040
               DFX 00000000000000800000000000000000
               DFX 00000000


;-----------------------------------------------------------------------------


